--------------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.all;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Entity configurable_z80_data Is
  Port(
      CLK : in    std_logic;
      CLK_CAP : in    std_logic;
      EXT_TRIGGER : in    std_logic;
      BUS_PHASE0 : in   std_logic;
      BUS_PHASE1 : in   std_logic;
      Z80CLK : in   std_logic;
      BUS_7M : in   std_logic;
      RWIN : in   std_logic;
      RWOUT : in   std_logic;
      DIN0 : in   std_logic;
      DIN1 : in   std_logic;
      DIN2 : in   std_logic;
      DIN3 : in   std_logic;
      DIN4 : in   std_logic;
      DIN5 : in   std_logic;
      DIN6 : in   std_logic;
      DIN7 : in   std_logic;
      Z80_A15 : in   std_logic;
      Z80_A14 : in   std_logic;
      Z80_A13 : in   std_logic;
      Z80_A12 : in   std_logic;
      Z80_A11 : in   std_logic;
      Z80_A10 : in   std_logic;
      Z80_A9 : in   std_logic;
      Z80_A8 : in   std_logic;
      Z80_A7 : in   std_logic;
      Z80_A6 : in   std_logic;
      Z80_A5 : in   std_logic;
      Z80_A4 : in   std_logic;
      Z80_A3 : in   std_logic;
      Z80_A2 : in   std_logic;
      Z80_A1 : in   std_logic;
      Z80_A0 : in   std_logic;
      Set0_Spare : in   std_logic_vector(1 downto 0);
      STATUS : out   std_logic;
      TCK : in   std_logic;
      TDI : in   std_logic;
      TDO : out   std_logic;
      TMS : in   std_logic;
      TRST : in   std_logic
      );
End configurable_z80_data;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
Architecture structure of configurable_z80_data is

   Component LAX_CFG32
      port
      (
        CH_TRIG  : in  STD_LOGIC_VECTOR(31 downto 0);
        CH_CAP   : in  STD_LOGIC_VECTOR(31 downto 0);
        CLK      : in  STD_LOGIC;
        CLK_CAP  : in  STD_LOGIC;
        STATUS   : out STD_LOGIC;
        DATAO    : out STD_LOGIC_VECTOR(31 downto 0);
        DATAI    : in  STD_LOGIC_VECTOR(31 downto 0);
        ADDR     : out STD_LOGIC_VECTOR(19 downto 0);
        WR       : out STD_LOGIC;
        RD       : out STD_LOGIC;
        SEL_CAP  : out STD_LOGIC_VECTOR(3 downto 0);
        SEL_TRIG : out STD_LOGIC_VECTOR(3 downto 0);
        TCK      : in  STD_LOGIC;
        TDI      : in  STD_LOGIC;
        TDO      : out STD_LOGIC;
        TMS      : in  STD_LOGIC;
        TRIGGER  : in  STD_LOGIC;
        TRST     : in  STD_LOGIC
      );
   End Component;

   Component memory_z80_data
      port
      (
        CLK      : in  STD_LOGIC;
        WE       : in  STD_LOGIC;
        ADDR     : in  STD_LOGIC_VECTOR(9 downto 0);
        DIN      : in  STD_LOGIC_VECTOR(31 downto 0);
        DOUT     : out STD_LOGIC_VECTOR(31 downto 0)
      );
   End Component;

   Signal Unique_Lax_Signal_Name_Mem_WE   : STD_LOGIC;
   Signal Unique_Lax_Signal_Name_Mem_DIN  : STD_LOGIC_VECTOR(31 downto 0);
   Signal Unique_Lax_Signal_Name_Mem_DOUT : STD_LOGIC_VECTOR(31 downto 0);

   Signal Unique_Lax_Signal_Name_Mem_ADDR : STD_LOGIC_VECTOR(19 Downto 0);
   Signal Unique_Lax_Signal_Name_selcap   : STD_LOGIC_VECTOR(3 downto 0);
   Signal Unique_Lax_Signal_Name_seltrig  : STD_LOGIC_VECTOR(3 downto 0);
   Signal Unique_Lax_Signal_Name_capin    : STD_LOGIC_VECTOR(31 downto 0);
   Signal Unique_Lax_Signal_Name_trigin   : STD_LOGIC_VECTOR(31 downto 0);


Begin
    Unique_Lax_Signal_Name_capin(0) <= BUS_PHASE0;
    Unique_Lax_Signal_Name_trigin(0) <= BUS_PHASE0;
    Unique_Lax_Signal_Name_capin(1) <= BUS_PHASE1;
    Unique_Lax_Signal_Name_trigin(1) <= BUS_PHASE1;
    Unique_Lax_Signal_Name_capin(2) <= Z80CLK;
    Unique_Lax_Signal_Name_trigin(2) <= Z80CLK;
    Unique_Lax_Signal_Name_capin(3) <= BUS_7M;
    Unique_Lax_Signal_Name_trigin(3) <= BUS_7M;
    Unique_Lax_Signal_Name_capin(4) <= RWIN;
    Unique_Lax_Signal_Name_trigin(4) <= RWIN;
    Unique_Lax_Signal_Name_capin(5) <= RWOUT;
    Unique_Lax_Signal_Name_trigin(5) <= RWOUT;
    Unique_Lax_Signal_Name_capin(6) <= DIN0;
    Unique_Lax_Signal_Name_trigin(6) <= DIN0;
    Unique_Lax_Signal_Name_capin(7) <= DIN1;
    Unique_Lax_Signal_Name_trigin(7) <= DIN1;
    Unique_Lax_Signal_Name_capin(8) <= DIN2;
    Unique_Lax_Signal_Name_trigin(8) <= DIN2;
    Unique_Lax_Signal_Name_capin(9) <= DIN3;
    Unique_Lax_Signal_Name_trigin(9) <= DIN3;
    Unique_Lax_Signal_Name_capin(10) <= DIN4;
    Unique_Lax_Signal_Name_trigin(10) <= DIN4;
    Unique_Lax_Signal_Name_capin(11) <= DIN5;
    Unique_Lax_Signal_Name_trigin(11) <= DIN5;
    Unique_Lax_Signal_Name_capin(12) <= DIN6;
    Unique_Lax_Signal_Name_trigin(12) <= DIN6;
    Unique_Lax_Signal_Name_capin(13) <= DIN7;
    Unique_Lax_Signal_Name_trigin(13) <= DIN7;
    Unique_Lax_Signal_Name_capin(14) <= Z80_A15;
    Unique_Lax_Signal_Name_trigin(14) <= Z80_A15;
    Unique_Lax_Signal_Name_capin(15) <= Z80_A14;
    Unique_Lax_Signal_Name_trigin(15) <= Z80_A14;
    Unique_Lax_Signal_Name_capin(16) <= Z80_A13;
    Unique_Lax_Signal_Name_trigin(16) <= Z80_A13;
    Unique_Lax_Signal_Name_capin(17) <= Z80_A12;
    Unique_Lax_Signal_Name_trigin(17) <= Z80_A12;
    Unique_Lax_Signal_Name_capin(18) <= Z80_A11;
    Unique_Lax_Signal_Name_trigin(18) <= Z80_A11;
    Unique_Lax_Signal_Name_capin(19) <= Z80_A10;
    Unique_Lax_Signal_Name_trigin(19) <= Z80_A10;
    Unique_Lax_Signal_Name_capin(20) <= Z80_A9;
    Unique_Lax_Signal_Name_trigin(20) <= Z80_A9;
    Unique_Lax_Signal_Name_capin(21) <= Z80_A8;
    Unique_Lax_Signal_Name_trigin(21) <= Z80_A8;
    Unique_Lax_Signal_Name_capin(22) <= Z80_A7;
    Unique_Lax_Signal_Name_trigin(22) <= Z80_A7;
    Unique_Lax_Signal_Name_capin(23) <= Z80_A6;
    Unique_Lax_Signal_Name_trigin(23) <= Z80_A6;
    Unique_Lax_Signal_Name_capin(24) <= Z80_A5;
    Unique_Lax_Signal_Name_trigin(24) <= Z80_A5;
    Unique_Lax_Signal_Name_capin(25) <= Z80_A4;
    Unique_Lax_Signal_Name_trigin(25) <= Z80_A4;
    Unique_Lax_Signal_Name_capin(26) <= Z80_A3;
    Unique_Lax_Signal_Name_trigin(26) <= Z80_A3;
    Unique_Lax_Signal_Name_capin(27) <= Z80_A2;
    Unique_Lax_Signal_Name_trigin(27) <= Z80_A2;
    Unique_Lax_Signal_Name_capin(28) <= Z80_A1;
    Unique_Lax_Signal_Name_trigin(28) <= Z80_A1;
    Unique_Lax_Signal_Name_capin(29) <= Z80_A0;
    Unique_Lax_Signal_Name_trigin(29) <= Z80_A0;
    Unique_Lax_Signal_Name_capin(30) <= Set0_Spare(0);
    Unique_Lax_Signal_Name_trigin(30) <= Set0_Spare(0);
    Unique_Lax_Signal_Name_capin(31) <= Set0_Spare(1);
    Unique_Lax_Signal_Name_trigin(31) <= Set0_Spare(1);

    U1 : LAX_CFG32
      Port Map
      (
        CH_CAP    => Unique_Lax_Signal_Name_capin,
        CH_TRIG   => Unique_Lax_Signal_Name_trigin,
        CLK      => CLK,
        CLK_CAP  => CLK_CAP,
        STATUS   => STATUS,
        DATAO    => Unique_Lax_Signal_Name_Mem_DIN,
        DATAI    => Unique_Lax_Signal_Name_Mem_DOUT,
        WR       => Unique_Lax_Signal_Name_Mem_WE,
        RD       => Open,
        ADDR     => Unique_Lax_Signal_Name_Mem_ADDR,
        SEL_CAP  => Unique_Lax_Signal_Name_selcap,
        SEL_TRIG => Unique_Lax_Signal_Name_seltrig,
        TCK      => TCK,
        TDI      => TDI,
        TDO      => TDO,
        TMS      => TMS,
        TRIGGER  => EXT_TRIGGER,
        TRST     => TRST
      );
    U2 : memory_z80_data
      Port Map
      (
        CLK      => CLK,
        DIN      => Unique_Lax_Signal_Name_Mem_DIN,
        DOUT     => Unique_Lax_Signal_Name_Mem_DOUT,
        ADDR     => Unique_Lax_Signal_Name_Mem_ADDR(9 Downto 0),
        WE       => Unique_Lax_Signal_Name_Mem_WE
      );

End structure;
--------------------------------------------------------------------------------
